<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_h5pactivity
 * @category    string
 * @copyright   2020 Ferran Recio <ferran@moodle.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['all_attempts'] = 'All user attempts';
$string['answer_checked'] = 'Answer checked';
$string['answer_correct'] = 'Your answer is correct';
$string['answer_fail'] = 'Incorrect answer';
$string['answer_incorrect'] = 'Your answer is incorrect';
$string['answer_pass'] = 'Correct answer';
$string['answer_unchecked'] = 'Answer unchecked';
$string['answer_unknown'] = 'Unknown answer';
$string['answer_text'] = 'Answer text';
$string['answer_noanswer'] = 'None';
$string['areapackage'] = 'Package file';
$string['attempt'] = 'Attempt';
$string['attempt_average'] = 'Attempts average scored';
$string['attempt_answer'] = 'Attempt answer';
$string['attempt_completion_no'] = 'This attempt is not marked as completed';
$string['attempt_completion_yes'] = 'This attempt is completed';
$string['attempt_first'] = 'First attempt';
$string['attempt_highest'] = 'Highest score attempt';
$string['attempt_last'] = 'Last attempt';
$string['attempt_none'] = 'No attempts are used for grading';
$string['attempt_number'] = 'Attempt #{$a}';
$string['attempt_success_fail'] = 'Fail';
$string['attempt_success_pass'] = 'Pass';
$string['attempt_success_unknown'] = 'Not reported';
$string['attempts'] = 'Attempts';
$string['attempts_report'] = 'Attempts report';
$string['attempts_none'] = 'This user has no attempts to display.';
$string['choice'] = 'Choice';
$string['completion'] = 'Completion';
$string['contentbank'] = 'More information about the content bank';
$string['contentbank_help'] = 'In the content bank you can create and store content using several authoring tools, including an integrated H5P creator.';
$string['correct_answer'] = 'Correct answer';
$string['deleteallattempts'] = 'Delete all H5P attempts';
$string['displayexport'] = 'Allow download';
$string['displayembed'] = 'Embed button';
$string['displaycopyright'] = 'Copyright button';
$string['dnduploadh5pactivity'] = 'Add an H5P activity';
$string['duration'] = 'Duration';
$string['enablesavestate'] = 'Save state';
$string['enablesavestate_help'] = 'Automatically save the user\'s current state. The user can return later and resume where they left off.';
$string['enabletracking'] = 'Enable attempt tracking';
$string['false'] = 'False';
$string['grade_grademethod'] = 'Grading method';
$string['grade_grademethod_help'] = 'When using point grading, the following methods are available for calculating the final grade:

* Highest grade of all attempts
* Average (mean) grade of all attempts
* First attempt (all other attempts are ignored)
* Last attempt (all other attempts are ignored)
* Don\'t use attempts for grading (disable grading calculation)';
$string['grade_manual'] = 'Don\'t calculate a grade';
$string['grade_highest_attempt'] = 'Highest grade';
$string['grade_average_attempt'] = 'Average grade';
$string['grade_last_attempt'] = 'Last attempt';
$string['grade_first_attempt'] = 'First attempt';
$string['grade_h5p'] = 'Grade: {$a}';
$string['h5pactivity:addinstance'] = 'Add a new H5P';
$string['h5pactivity:reviewattempts'] = 'Review H5P attempts';
$string['h5pactivity:submit'] = 'Submit H5P attempts';
$string['h5pactivity:view'] = 'View H5P';
$string['h5pactivityfieldset'] = 'H5P settings';
$string['h5pactivityname'] = 'H5P';
$string['h5pactivitysettings'] = 'Settings';
$string['h5pattempts'] = 'Attempt options';
$string['h5pdisplay'] = 'H5P options';
$string['maxscore'] = 'Max score';
$string['modulename'] = 'H5P';
$string['modulename_help'] = 'H5P is an abbreviation for HTML5 Package - interactive content such as presentations, videos and other multimedia, questions, quizzes, games and more. The H5P activity enables H5P to be uploaded and added to a course.

Any question attempts are marked automatically, and the grade is recorded in the gradebook.';
$string['modulename_link'] = 'mod/h5pactivity/view';
$string['modulenameplural'] = 'H5P';
$string['myattempts'] = 'My attempts';
$string['newsubmissions'] = 'H5P submitted';
$string['no_compatible_track'] = 'This interaction ({$a}) does not provide tracking information or the tracking
        provided is not compatible with the current activity version.';
$string['noparticipants'] = 'No participants to display';
$string['opencontentbank'] = '<a href="{$a}" target="_blank">Access the H5P file in the content bank</a> (opens in a new window).';
$string['outcome'] = 'Outcome';
$string['package'] = 'Package file';
$string['package_help'] = 'The package file is a h5p file containing H5P interactive content.';
$string['page-mod-h5pactivity-x'] = 'Any H5P module page';
$string['pluginadministration'] = 'H5P administration';
$string['pluginname'] = 'H5P';
$string['previewmode'] = 'This content is displayed in preview mode. No attempt tracking will be stored.';
$string['privacy:metadata:attempt'] = 'The attempt number';
$string['privacy:metadata:rawscore'] = 'The score obtained';
$string['privacy:metadata:timecreated'] = 'The time when the tracked element was created';
$string['privacy:metadata:timemodified'] = 'The last time element was tracked';
$string['privacy:metadata:userid'] = 'The ID of the user who accessed the H5P activity';
$string['privacy:metadata:xapisummary'] = 'The H5P activity contains information relating to the xAPI content state stored by the user.';
$string['privacy:metadata:xapi_track'] = 'Attempt tracking information';
$string['privacy:metadata:xapi_track_results'] = 'Attempt results tracking information';
$string['report_viewed'] = 'Report viewed';
$string['result_compound'] = 'Combined partial score';
$string['result_fill-in'] = 'Fill-in text';
$string['result_fill-in_gap'] = 'Gap #{$a}';
$string['result_matching'] = 'Matching choice';
$string['result_other'] = 'Unknown interaction type';
$string['result_sequencing_choice'] = 'Positions';
$string['result_sequencing_answer'] = 'Position value';
$string['result_sequencing_position'] = '#{$a}';
$string['review_all_attempts'] = 'View all attempts ({$a} submitted)';
$string['review_mode'] = 'Review attempts';
$string['review_my_attempts'] = 'View my attempts';
$string['review_user_attempts'] = 'View user attempts ({$a})';
$string['review_none'] = 'Participants cannot review their own attempts';
$string['review_on_completion'] = 'Participants can review their own attempts';
$string['savestatefreq'] = 'Save state frequency';
$string['savestatefreq_help'] = 'How often (in seconds) that the user\'s current state is saved.';
$string['score'] = 'Score';
$string['score_out_of'] = '{$a->rawscore} out of {$a->maxscore}';
$string['search:activity'] = 'H5P - activity information';
$string['startdate'] = 'Start date';
$string['statement_received'] = 'xAPI statement received';
$string['totalscore'] = 'Total score';
$string['tracking_messages'] = 'Some H5P provide attempt tracking data for advanced reporting such as number of attempts, responses and grades. Note: Some H5P don\'t provide attempt tracking data. In such cases, the following settings will have no effect.';
$string['true'] = 'True';
$string['usecontentbank'] = 'Use the <a href="{$a}" target="_blank">content bank (opens in new window)</a> to manage your H5P files';
$string['view'] = 'View';
$string['view_report'] = 'View report';
